varying vec2 texture_coordinate;
uniform sampler2D source;
uniform sampler2D image;
uniform float greyness;
uniform float alpha;
/* either 1 or -1 */
uniform int xrand;
uniform int yrand;

void main() {
	vec3 color = texture2D(source, texture_coordinate).rgb;
	float grey = (color.r + color.g + color.b)/3.0 * greyness;
	vec3 weight = texture2D(image, texture_coordinate * vec2(xrand, yrand)).rgb;

	/* greyness multiplied by noise map source */
	/* alpha? */
	gl_FragColor = vec4((color.r*(1.0-greyness)+grey)*weight.r, (color.g*(1.0-greyness)+grey)*weight.g, (color.b*(1.0-greyness)+grey)*weight.b, alpha);
}
